/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.entity;

import forge.com.cursee.more_bows_and_arrows.core.entity.ArrowHitsBlockInteractions;
import forge.com.cursee.more_bows_and_arrows.core.entity.ArrowHitsEntityInteractions;
import forge.com.cursee.more_bows_and_arrows.core.tier.ArrowTier;
import forge.com.cursee.more_bows_and_arrows.platform.Services;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class TieredArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(TieredArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ArrowTier tier;

    public TieredArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level, ArrowTier tier) {
        super(entityType, level);
        this.tier = tier;
        this.setVariant(this.tier);
        this.m_36781_(this.m_36789_() + (double)this.tier.bonusDamage());
    }

    public TieredArrowEntity(double x, double y, double z, Level level, ArrowTier tier) {
        super(Services.PLATFORM.entityFromTier(tier), x, y, z, level);
        this.tier = tier;
        this.setVariant(tier);
        this.m_36781_(this.m_36789_() + (double)this.tier.bonusDamage());
    }

    public TieredArrowEntity(LivingEntity livingEntity, Level level, ArrowTier tier) {
        super(Services.PLATFORM.entityFromTier(tier), livingEntity, level);
        this.tier = tier;
        this.setVariant(tier);
        this.m_36781_(this.m_36789_() + (double)this.tier.bonusDamage());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(ArrowTier tier) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(tier.getId() & 0xFF));
    }

    public ArrowTier getVariant() {
        return ArrowTier.byId(this.getTypeVariant() & 0xFF);
    }

    public float bonusDamage() {
        return this.getVariant().bonusDamage();
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Services.PLATFORM.itemFromTier(this.tier));
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        ArrowHitsEntityInteractions.interact(this, this.m_19749_(), entityHitResult);
        super.m_5790_(entityHitResult);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        ArrowHitsBlockInteractions.interact(this, this.m_19749_(), blockHitResult);
        super.m_8060_(blockHitResult);
    }
}

